Notebook[{

Cell[CellGroupData[{
Cell["\<\

conformal invariance of electromagnetism with xConf \
\>", "Subtitle",
 FontSize->24,ExpressionUUID->"b73ea991-a1e7-4945-91d0-4054ec287b18"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<xAct`xConf`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"678b56c2-43ca-42da-a7c6-2d1dc4257ac4"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"0ce99d44-bb71-4193-8eeb-2e650142e254"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"9bd8a64a-5868-4622-9f7f-dcd62d3f312c"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"aac469e0-f2f7-45e1-9a8c-df9a5b0551f9"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"7e0716c9-2146-4b6c-b648-c579bb2f9fd7"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"bdae42f0-759d-4d57-9dcc-1f616a5e09fe"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"e47f4a19-eca6-4eb7-9761-9684d56ebd5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"832f7f9d-739f-4a93-8a5e-3ff772edb656"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"39f51067-49f3-446c-800e-6dd89e2cce37"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"8a3be199-d710-4ca2-a558-bf0ba06082e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xConf`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.0.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "4", ",", "4"}], "}"}]}],
  SequenceForm["Package xAct`xConf`  version ", "0.0.1", ", ", {2025, 4, 4}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"8884ef41-743c-48ea-803a-3ae89c2386ae"],

Cell[BoxData["\<\"CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"5cdc4016-43cb-4129-befc-78f6e9ae6656"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"8bc6de2e-45e7-4ac2-9755-f4f7994f31fa"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"6f5c6909-a5e2-419d-be2a-07b92e410260"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"7a7fd066-3af5-49ec-9959-47463e085d43"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$PrePrint", 
   "\[InvisibleSpace]", "\<\" assigned value \"\>", "\[InvisibleSpace]", 
   "ScreenDollarIndices"}],
  SequenceForm[
  "** Variable ", $PrePrint, " assigned value ", 
   xAct`xTensor`ScreenDollarIndices],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"367fa104-fa5d-4081-b703-46f733c60a21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "AllowUpperDerivatives", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ContractMetric",
    "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`AllowUpperDerivatives, " of ", 
   xAct`xTensor`ContractMetric, " changed from ", False, " to ", True],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"3d0e6bf0-396e-4555-b40e-490aed7077f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "UseMetricOnVBundle", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ToCanonical", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", "All", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "None"}],
  SequenceForm[
  "** Option ", xAct`xTensor`UseMetricOnVBundle, " of ", 
   xAct`xTensor`ToCanonical, " changed from ", All, " to ", None],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"25730928-72f6-44e1-ab2f-d651da7631c4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Mu]", ",", "\[Nu]", 
     ",", "\[Lambda]", ",", "\[Sigma]"}], "}"}]}], "]"}], "\n", 
 RowBox[{
  RowBox[{"DefMetric", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}]}], "]"}], ",", "CD", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<;\>\"", ",", "\"\<\[Del]\>\""}], "}"}], ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<g\>\""}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"e5a250ec-cb66-4862-b7ba-440ac45c6456"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", "manifold ", $CellContext`M,
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"33f7ef02-eb6e-43b0-8f43-f7952c62c753"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"bf146585-3253-4e3e-b70a-599b42041034"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"b8a00a84-dc94-46df-8ef8-787cd22fe598"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"e9a48748-1f68-45d9-950d-e5a5f8dcc1a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"f3ff64d0-afcb-43fa-bf66-b7e192e3d992"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag\[Dagger][-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"b699cc6d-68fd-45b5-8360-f39a51a67b9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"45dbf8df-72ea-4c5f-9c9c-5e2701503b97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"8036922c-0422-4434-a19a-43e7803e4210"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"f41103cf-0526-449b-9c7a-52be9309d8e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"179b85b5-4986-4874-9a3e-e09b46be047a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"70a788ec-f88c-43ce-bc8d-4eed0c3b4b38"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"573273b7-8cab-4e59-811f-3af3a5d535c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"4624f1ac-7766-452e-81bb-cb9a71e36b32"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"d068ad9b-5794-43dc-b6ec-39ac52c65979"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"eba79995-12ea-4674-be94-0bf054ff01aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"bf14659b-46ef-46d0-9e8d-b4e0812f9c21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"0be6e9a4-430a-42ca-96f2-9d18ad818cfb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"dc99514e-c776-4f34-a5ee-9b7a194120c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"a1ff1cdc-6736-4355-ba31-dfa805613200"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"3e460bf8-7544-41f7-ab82-d01f34246a96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"fa9bb003-1414-41b1-8d9b-11a5a1d93223"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"13e59fb4-5ed9-4b52-8e1d-6fea43f407e6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConformalMetric", "[", 
  RowBox[{"g", ",", "S", ",", 
   RowBox[{"FrameColor", "->", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"95bcf5b3-6f61-4afb-83d6-2fcf0e9969b6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Choosing color \"\>", "\[InvisibleSpace]", 
   TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>,
    "RGBColorSwatchTemplate"], 
   "\[InvisibleSpace]", "\<\" for this conformal frame.\"\>"}],
  SequenceForm["Choosing color ", 
   RGBColor[1, 0, 0], " for this conformal frame."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"188f7599-f0e1-4e84-8ec4-6a6c3a878545"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"fe5def2a-ff3c-406b-b6cd-caee1f4c3655"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"gS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Sigma]$2692"}], ",", 
     RowBox[{"-", "\[Sigma]$2693"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`gS2[-$CellContext`\[Sigma]$2692, -$CellContext`\[Sigma]$2693],
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"11652266-8332-4bd8-813c-264b0d04528a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inverse metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"InvgS2", "[", 
    RowBox[{"\[Sigma]$2692", ",", "\[Sigma]$2693"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Metric is frozen!\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "inverse metric tensor ", 
   $CellContext`InvgS2[$CellContext`\[Sigma]$2692, \
$CellContext`\[Sigma]$2693], ". ", "Metric is frozen!"],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"73d9b2cd-f5b5-4fd7-b6d6-229ed098e7bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilongS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilongS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"f12a84b9-d23b-473c-82eb-ec78b41504bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetragS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetragS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"800979e1-0c98-458d-ac72-34c4ead8d548"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetragS2\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetragS2\[Dagger][-$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"fd03884b-52c6-42da-842b-579b112b99be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDgS2", "[", 
    RowBox[{"-", "\[Sigma]$2692"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDgS2[-$CellContext`\[Sigma]$2692], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"1b4f81a4-3920-4d1d-8d6e-9b64c5240efe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCDgS2[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"4e72630b-e838-4a4b-b5ca-d46d3fc9f7b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCDgS2[$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"c31cd38c-b404-4c7b-8ba9-ed1f53db4ec7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannDownCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannDownCDgS2[-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"813567f3-27af-4e6f-a654-9a4e5cc077bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", "\[Lambda]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], $CellContext`\[Lambda]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"22da9efb-e144-42f7-ae6f-160ecf59eb5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"ce567008-cf53-4627-84d0-951abd8fee7b"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"1368d19c-1a87-45f1-8b8c-75e468aa2d11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCDgS2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCDgS2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"23e7325f-3f36-4dd2-a72f-9885488ecc1f"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"27e0180d-21bb-4328-9f61-a7f1dd77511e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"01763137-33dc-4162-8366-3701997089c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"99a48120-a36a-4280-9064-e1fef0ee82d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"908f9e15-67f7-476f-b2d8-5ba6d3141a39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCDgS2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCDgS2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"7504a2b5-fafc-4e55-993e-19dc5c5c3f17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"4546106b-519e-40b5-b605-95c60d6057ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"c09e43a6-5a1f-4c93-a88b-a93feb059a3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"DetgS2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`DetgS2[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"9e837d66-73cd-46ec-a8bc-3c572f102ff3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "gS2", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`gS2], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"02b008ae-bd93-4d4e-b11b-0d845a0c60bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "g", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`g], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"9ebe9df5-655d-4ccb-bf01-a32a19a1c9cf"]
}, Open  ]]
}, Open  ]],

Cell["We define the vector potential of electromagnetism", \
"Text",ExpressionUUID->"a1305cd5-6f47-4958-af18-a0b53eb35395"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], ",", 
   RowBox[{"{", "M", "}"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<A\>\""}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"827e302a-5927-4d49-9568-2d8833ead39c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"A", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`A[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"2eb10d37-5a92-4e85-9cf9-f3f97e3e2aa4"]
}, Open  ]],

Cell["The invariance stand only for this weight ", \
"Text",ExpressionUUID->"4aaafd01-97dd-4fa4-8236-fe12762a834c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConformalWeight", "[", "A", "]"}], "=", 
   RowBox[{"-", "1"}]}], ";"}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"1e91e25d-c805-4fbe-afe0-bd98bfbc32c4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2"}], "]"}], "[", 
  RowBox[{"A", "[", 
   RowBox[{"-", "\[Alpha]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2"}], "]"}], "[", 
  RowBox[{"A", "[", "\[Alpha]", "]"}], "]"}]}], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"55b1d690-4474-4e62-9431-ee7d6150e43d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCDCDgS2[$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[7]:=",ExpressionUUID->"49d9fd35-cbb4-4b41-9849-faf1d6af59b5"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"A", 
      StyleBox[GridBox[{
         {" "},
         {"\[Alpha]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`A[-$CellContext`\[Alpha]],
  Editable->False]], "Output",
 CellLabel->"Out[7]=",ExpressionUUID->"d8d0874a-65b8-4e95-b70b-85db94007e50"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"A", 
        StyleBox[GridBox[{
           {" "},
           {"\[Beta]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A[-$CellContext`\[Beta]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Alpha]", "\[Beta]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
    Editable->False]}], 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False], "2"]]], "Output",
 CellLabel->"Out[8]=",ExpressionUUID->"e61dfcc4-a7a1-4595-be24-5c5a63b6bc4c"]
}, Open  ]],

Cell["We first check that the Faraday tensor is invariant", \
"Text",ExpressionUUID->"33eea387-d67d-4516-9f9f-25560a350318"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Faraday", "[", 
   RowBox[{"\[Mu]_", ",", "\[Nu]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"CD", "[", "\[Mu]", "]"}], "[", 
    RowBox[{"A", "[", "\[Nu]", "]"}], "]"}], "-", 
   RowBox[{
    RowBox[{"CD", "[", "\[Nu]", "]"}], "[", 
    RowBox[{"A", "[", "\[Mu]", "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"f32b3430-c787-48fa-ba94-db8fa9632050"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConformalTransformation", "[", 
    RowBox[{"g", ",", "gS2"}], "]"}], "[", 
   RowBox[{"Faraday", "[", 
    RowBox[{
     RowBox[{"-", "\[Mu]"}], ",", 
     RowBox[{"-", "\[Nu]"}]}], "]"}], "]"}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"503cfec3-9e69-43f6-999a-34b178e25aab"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "\[Mu]"], GridBox[{
       {"A", 
        StyleBox[GridBox[{
           {" "},
           {"\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`\[Mu]][
    $CellContext`A[-$CellContext`\[Nu]]],
   Editable->False], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "\[Nu]"], GridBox[{
       {"A", 
        StyleBox[GridBox[{
           {" "},
           {"\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`\[Nu]][
    $CellContext`A[-$CellContext`\[Mu]]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[10]=",ExpressionUUID->"41a42ef7-99eb-4d78-af5b-95b5985a90c4"]
}, Open  ]],

Cell["We check the first set of equations in vacuum", \
"Text",ExpressionUUID->"938a3157-6f59-482c-b07d-65b359d01c47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConformalTransformation", "[", 
     RowBox[{"g", ",", "gS2"}], "]"}], "[", 
    RowBox[{
     RowBox[{"CD", "[", "\[Beta]", "]"}], "[", 
     RowBox[{"Faraday", "[", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], ",", 
       RowBox[{"-", "\[Alpha]"}]}], "]"}], "]"}], "]"}], "//", 
   "ContractMetric"}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"8c774331-b576-4bba-8226-8e0edf9a9747"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], GridBox[{
         {"A", 
          StyleBox[GridBox[{
             {"\[Beta]"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`A[$CellContext`\[Beta]]]],
     Editable->False], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Beta]"], 
      SuperscriptBox["\[Del]", "\[Beta]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Alpha]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Beta]][
     $CellContext`CD[$CellContext`\[Beta]][
      $CellContext`A[-$CellContext`\[Alpha]]]],
    Editable->False], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]]}]], "Output",
 CellLabel->
  "Out[11]=",ExpressionUUID->"ceee18d6-a5a4-418a-8e10-83aa5833412e"]
}, Open  ]],

Cell["Then the Bianchi identity for the Farady tensor.", \
"Text",ExpressionUUID->"72b0d9a2-b191-4ab4-8617-c5cf8b79fd34"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConformalTransformation", "[", 
     RowBox[{"g", ",", "gS2"}], "]"}], "[", 
    RowBox[{"Antisymmetrize", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "\[Gamma]"}], "]"}], "[", 
       RowBox[{"Faraday", "[", 
        RowBox[{
         RowBox[{"-", "\[Alpha]"}], ",", 
         RowBox[{"-", "\[Beta]"}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "\[Alpha]"}], ",", 
        RowBox[{"-", "\[Beta]"}], ",", 
        RowBox[{"-", "\[Gamma]"}]}], "}"}]}], "]"}], "]"}], "//", 
   "ContractMetric"}], "//", "ToCanonical"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Antisymmetrize", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "\[Gamma]"}], "]"}], "[", 
      RowBox[{"Faraday", "[", 
       RowBox[{
        RowBox[{"-", "\[Alpha]"}], ",", 
        RowBox[{"-", "\[Beta]"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], ",", 
       RowBox[{"-", "\[Beta]"}], ",", 
       RowBox[{"-", "\[Gamma]"}]}], "}"}]}], "]"}], "//", "ContractMetric"}], 
  "//", "ToCanonical"}]}], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"13d872f9-be0d-489b-9094-9e74a5a2d0d6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], 
      SubscriptBox["\[Del]", "\[Beta]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Gamma]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`A[-$CellContext`\[Gamma]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], 
      SubscriptBox["\[Del]", "\[Gamma]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Beta]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`A[-$CellContext`\[Beta]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Beta]"], 
      SubscriptBox["\[Del]", "\[Alpha]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Gamma]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Beta]][
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`A[-$CellContext`\[Gamma]]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Beta]"], 
      SubscriptBox["\[Del]", "\[Gamma]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Alpha]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Beta]][
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`A[-$CellContext`\[Alpha]]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Gamma]"], 
      SubscriptBox["\[Del]", "\[Alpha]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Beta]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Gamma]][
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`A[-$CellContext`\[Beta]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Gamma]"], 
      SubscriptBox["\[Del]", "\[Beta]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Alpha]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Gamma]][
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`A[-$CellContext`\[Alpha]]]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[12]=",ExpressionUUID->"3cd6ce7e-2ef2-4c5f-8bac-41b466173c83"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], 
      SubscriptBox["\[Del]", "\[Beta]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Gamma]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`A[-$CellContext`\[Gamma]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Alpha]"], 
      SubscriptBox["\[Del]", "\[Gamma]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Beta]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Alpha]][
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`A[-$CellContext`\[Beta]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Beta]"], 
      SubscriptBox["\[Del]", "\[Alpha]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Gamma]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Beta]][
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`A[-$CellContext`\[Gamma]]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Beta]"], 
      SubscriptBox["\[Del]", "\[Gamma]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Alpha]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Beta]][
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`A[-$CellContext`\[Alpha]]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Gamma]"], 
      SubscriptBox["\[Del]", "\[Alpha]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Beta]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Gamma]][
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`A[-$CellContext`\[Beta]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[Del]", "\[Gamma]"], 
      SubscriptBox["\[Del]", "\[Beta]"], GridBox[{
        {"A", 
         StyleBox[GridBox[{
            {" "},
            {"\[Alpha]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`\[Gamma]][
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`A[-$CellContext`\[Alpha]]]],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[13]=",ExpressionUUID->"5f5298fb-1a7e-45cd-9198-dda71df349bf"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1222, 723},
WindowMargins->{{Automatic, 74}, {Automatic, 6}},
Visible->True,
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[{
      ButtonBox[
      "\"\[Dagger]\"", ButtonFunction :> Exit[], Appearance -> Automatic, 
       Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluatorStart"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\[RightTriangle]\"", ButtonFunction :> 
       FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateNotebook"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"EvalInit\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateInitialization"]], Evaluator -> None,
        Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"Init\"", 
       ButtonFunction :> (Module[{Utility`Toolbar`cell = NotebookSelection[
             SelectedNotebook[]], Utility`Toolbar`isInit}, 
          Utility`Toolbar`isInit = ReplaceAll[InitializationCell, 
             Options[Utility`Toolbar`cell, InitializationCell]]; If[
            TrueQ[
             Or[
             Utility`Toolbar`isInit == True, Utility`Toolbar`isInit == On]], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> False], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> True]]]; 
        Null), Appearance -> Automatic, Evaluator -> Automatic, Method -> 
       "Preemptive"], 
      ButtonBox["\"DeInit\"", ButtonFunction :> SetOptions[
         NotebookSelection[
          SelectedNotebook[]], InitializationCell -> False], Appearance -> 
       Automatic, Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"\[DeleteKey]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["DeleteGeneratedCells"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"]}, "Row", 
     DisplayFunction -> (
      RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3, 
        "\[InvisibleSpace]", #4, "\[InvisibleSpace]", #5, 
        "\[InvisibleSpace]", #6, "\[InvisibleSpace]", #7}]& ), 
     InterpretationFunction -> (RowBox[{"Row", "[", 
        RowBox[{"{", 
          RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7}], 
          "}"}], "]"}]& )]], "DockedCell"]},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"14.1 pour Mac OS X ARM (64-bit) (July 16, 2024)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "PastelColor.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"d5a261cc-427a-495a-8802-fcb83c286279"
]

